#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "EOS Fluid Characterization \"SCN for MWs and SGs\""
show title

$Expt << END
#                                                        Tb            Tc          Pc                       
#  Component       LMW          MW          SG           (C)          (K)        (bar)         AF         VTran
#------------   ---------   ---------   ---------   ------------   ---------   ---------   ---------   ----------
     N2              NaN      28.014     0.28339     -195.90291     126.200     33.9800     0.03700     -0.16758
     CO2             NaN      44.010     0.76193      -88.26608     304.120     73.7400     0.22500      0.00191
     C1              NaN      16.043     0.14609     -161.59338     190.560     45.9900     0.01100     -0.14996
     C2              NaN      30.070     0.32976      -88.71667     305.320     48.7200     0.09900     -0.06280
     C3              NaN      44.097     0.50977      -42.21618     369.830     42.4800     0.15200     -0.06381
     I-C4            NaN      58.123     0.57043      -11.65811     407.850     36.4000     0.18600     -0.06197
     N-C4            NaN      58.123     0.59055       -0.51619     425.120     37.9600     0.20000     -0.05393
     I-C5            NaN      72.150     0.62952       28.01296     460.390     33.8100     0.22900     -0.05646
     N-C5            NaN      72.150     0.63585       36.18684     469.700     33.7000     0.25200     -0.02928
     C6           77.714      84.751     0.69921       64.83930     513.482     33.2738     0.24565     -0.02474
     C7           91.551      98.595     0.72940       94.25535     548.497     30.6745     0.28230     -0.00820
     C8          105.403     112.460     0.75398      121.35092     579.790     28.5096     0.31809      0.00569
     C9          119.362     126.496     0.77457      146.51023     608.034     26.6688     0.35344      0.01630
     C10         133.445     140.601     0.79195      169.99044     633.638     25.0631     0.38878      0.02554
     C11         147.592     154.767     0.80682      191.98102     656.967     23.6445     0.42415      0.03372
     C12         161.797     168.989     0.81967      212.63178     678.316     22.3800     0.45954      0.04105
     C13         176.052     183.259     0.83088      232.06704     697.934     21.2452     0.49151      0.04765
     C14         190.351     197.571     0.84075      250.39330     716.029     20.2213     0.52508      0.05359
     C15         204.687     211.919     0.84950      267.70376     732.779     19.2934     0.55826      0.05893
     C16         219.058     226.301     0.85730      284.08099     748.334     18.4493     0.59100      0.06371
     C17         233.458     240.711     0.86430      299.59884     762.825     17.6789     0.62328      0.06797
     C18         247.886     255.149     0.87063      314.32372     776.364     16.9733     0.65506      0.07174
     C19         262.339     269.611     0.87636      328.31560     789.048     16.3254     0.68633      0.07505
     C20         276.815     284.096     0.88158      341.62882     800.961     15.7287     0.71706      0.07793
     C21         291.313     298.601     0.88635      354.31270     812.177     15.1776     0.74726      0.08042
     C22         305.830     313.126     0.89074      366.41217     822.761     14.6675     0.77691      0.08254
     C23         320.366     327.669     0.89477      377.96816     832.769     14.1940     0.80601      0.08432
     C24         334.920     342.230     0.89850      389.01807     842.251     13.7535     0.83456      0.08579
     C25         349.491     356.807     0.90196      399.59611     851.252     13.3427     0.86257      0.08698
     C26         364.077     371.400     0.90517      409.73362     859.812     12.9588     0.89004      0.08790
     C27         378.678     386.007     0.90817      419.45935     867.964     12.5994     0.91698      0.08859
     C28         393.293     400.628     0.91096      428.79974     875.742     12.2620     0.94339      0.08906
     C29         407.922     415.262     0.91358      437.77907     883.172     11.9449     0.96930      0.08933
     C30+        422.563     602.891     0.93649      528.47876     956.060      9.0961     1.25946      0.08196
END
set xlabel "Molecular Weight"
set ylabel "Specific Gravity"
set output "Figures/Table_002_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:4 with points notitle

set title "Gamma Model of Lab3_MDT1_Contaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.63      112.46      113.23     1.1039e-01    1.1755e-01    4.7659e-02    5.1095e-02
    119.36      126.50      126.09     8.7711e-02    9.8594e-02    4.2593e-02    4.7724e-02
    133.44      140.60      140.30     7.7769e-02    7.9549e-02    4.1976e-02    4.2846e-02
    147.59      154.77      154.52     6.2187e-02    6.7800e-02    3.6948e-02    4.0218e-02
    161.80      168.99      168.77     5.4506e-02    5.9146e-02    3.5360e-02    3.8320e-02
    176.05      183.26      183.06     5.4919e-02    5.2268e-02    3.8637e-02    3.6731e-02
    190.35      197.57      197.38     5.2220e-02    4.6570e-02    3.9607e-02    3.5288e-02
    204.69      211.92      211.74     4.8220e-02    4.1729e-02    3.9229e-02    3.3920e-02
    219.06      226.30      226.13     4.2675e-02    3.7547e-02    3.7074e-02    3.2594e-02
    233.46      240.71      240.55     3.9902e-02    3.3890e-02    3.6872e-02    3.1296e-02
    247.89      255.15      254.99     3.6563e-02    3.0666e-02    3.5814e-02    3.0019e-02
    262.34      269.61      269.46     3.1485e-02    2.7804e-02    3.2588e-02    2.8761e-02
    276.82      284.10      283.95     2.4680e-02    2.5251e-02    2.6917e-02    2.7525e-02
    291.31      298.60      298.46     2.0568e-02    2.2964e-02    2.3578e-02    2.6311e-02
    305.83      313.13      312.98     1.8912e-02    2.0908e-02    2.2733e-02    2.5122e-02
    320.37      327.67      327.53     1.7562e-02    1.9056e-02    2.2091e-02    2.3960e-02
    334.92      342.23      342.09     1.5213e-02    1.7382e-02    1.9986e-02    2.2828e-02
    349.49      356.81      356.67     1.4002e-02    1.5868e-02    1.9180e-02    2.1727e-02
    364.08      371.40      371.27     1.3072e-02    1.4495e-02    1.8638e-02    2.0659e-02
    378.68      386.01      385.88     1.3096e-02    1.3249e-02    1.9406e-02    1.9626e-02
    393.29      400.63      400.50     1.2208e-02    1.2116e-02    1.8776e-02    1.8628e-02
    407.92      415.26      415.13     1.0790e-02    1.1085e-02    1.7201e-02    1.7666e-02
    422.56      602.89      596.59     1.4135e-01    1.2312e-01    3.2714e-01    2.8198e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_002_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT1_Decontaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.63      112.46      113.23     1.1605e-01    1.1561e-01    4.9834e-02    4.9981e-02
    119.36      126.50      126.09     9.2210e-02    9.6967e-02    4.4537e-02    4.6683e-02
    133.44      140.60      140.30     8.1719e-02    7.8236e-02    4.3871e-02    4.1913e-02
    147.59      154.77      154.52     6.5034e-02    6.6681e-02    3.8431e-02    3.9341e-02
    161.80      168.99      168.77     5.6043e-02    5.8170e-02    3.6161e-02    3.7485e-02
    176.05      183.26      183.06     5.4545e-02    5.1406e-02    3.8167e-02    3.5930e-02
    190.35      197.57      197.38     5.0346e-02    4.5802e-02    3.7980e-02    3.4519e-02
    204.69      211.92      211.74     4.3633e-02    4.1041e-02    3.5306e-02    3.3181e-02
    219.06      226.30      226.13     3.6542e-02    3.6927e-02    3.1575e-02    3.1884e-02
    233.46      240.71      240.55     3.1898e-02    3.3331e-02    2.9317e-02    3.0614e-02
    247.89      255.15      254.99     2.9177e-02    3.0160e-02    2.8425e-02    2.9364e-02
    262.34      269.61      269.46     2.8135e-02    2.7345e-02    2.8964e-02    2.8134e-02
    276.82      284.10      283.95     2.4409e-02    2.4834e-02    2.6478e-02    2.6925e-02
    291.31      298.60      298.46     2.1326e-02    2.2585e-02    2.4314e-02    2.5737e-02
    305.83      313.13      312.98     1.9794e-02    2.0563e-02    2.3665e-02    2.4574e-02
    320.37      327.67      327.53     1.8365e-02    1.8741e-02    2.2977e-02    2.3438e-02
    334.92      342.23      342.09     1.5966e-02    1.7096e-02    2.0864e-02    2.2330e-02
    349.49      356.81      356.67     1.4682e-02    1.5606e-02    2.0002e-02    2.1253e-02
    364.08      371.40      371.27     1.3736e-02    1.4256e-02    1.9478e-02    2.0209e-02
    378.68      386.01      385.88     1.3754e-02    1.3030e-02    2.0272e-02    1.9198e-02
    393.29      400.63      400.50     1.2825e-02    1.1916e-02    1.9618e-02    1.8222e-02
    407.92      415.26      415.13     1.1328e-02    1.0902e-02    1.7962e-02    1.7281e-02
    422.56      602.89      596.59     1.4848e-01    1.2109e-01    3.4180e-01    2.7583e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_003_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT2_Contaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.11      112.46      112.94     1.1780e-01    1.1984e-01    5.1674e-02    5.2790e-02
    119.36      126.50      126.10     9.0283e-02    9.6703e-02    4.4546e-02    4.7564e-02
    133.44      140.60      140.31     8.1226e-02    7.8597e-02    4.4546e-02    4.3015e-02
    147.59      154.77      154.52     6.4936e-02    6.7285e-02    3.9201e-02    4.0555e-02
    161.80      168.99      168.77     5.6961e-02    5.8906e-02    3.7546e-02    3.8778e-02
    176.05      183.26      183.06     5.5019e-02    5.2218e-02    3.9328e-02    3.7286e-02
    190.35      197.57      197.39     4.8886e-02    4.6661e-02    3.7673e-02    3.5925e-02
    204.69      211.92      211.74     4.6038e-02    4.1925e-02    3.8055e-02    3.4627e-02
    219.06      226.30      226.13     3.8787e-02    3.7823e-02    3.4237e-02    3.3362e-02
    233.46      240.71      240.55     3.4025e-02    3.4227e-02    3.1946e-02    3.2115e-02
    247.89      255.15      254.99     3.2739e-02    3.1049e-02    3.2582e-02    3.0882e-02
    262.34      269.61      269.46     3.0378e-02    2.8222e-02    3.1946e-02    2.9662e-02
    276.82      284.10      283.95     2.4924e-02    2.5693e-02    2.7619e-02    2.8456e-02
    291.31      298.60      298.46     2.2511e-02    2.3422e-02    2.6219e-02    2.7267e-02
    305.83      313.13      312.99     1.9799e-02    2.1377e-02    2.4182e-02    2.6097e-02
    320.37      327.67      327.53     1.8522e-02    1.9529e-02    2.3673e-02    2.4950e-02
    334.92      342.23      342.10     1.6685e-02    1.7857e-02    2.2273e-02    2.3827e-02
    349.49      356.81      356.67     1.5364e-02    1.6339e-02    2.1382e-02    2.2732e-02
    364.08      371.40      371.27     1.4321e-02    1.4961e-02    2.0746e-02    2.1665e-02
    378.68      386.01      385.88     1.4624e-02    1.3706e-02    2.2019e-02    2.0630e-02
    393.29      400.63      400.50     1.2054e-02    1.2563e-02    1.8837e-02    1.9626e-02
    407.92      415.26      415.14     1.2494e-02    1.1521e-02    2.0237e-02    1.8656e-02
    422.56      602.89      601.47     1.3163e-01    1.3164e-01    3.0953e-01    3.0885e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_005_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT2_Decontaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.11      112.46      112.94     1.1936e-01    1.1935e-01    5.2293e-02    5.2512e-02
    119.36      126.50      126.10     9.1476e-02    9.6309e-02    4.5080e-02    4.7314e-02
    133.44      140.60      140.31     8.2289e-02    7.8276e-02    4.5075e-02    4.2788e-02
    147.59      154.77      154.52     6.5706e-02    6.7011e-02    3.9618e-02    4.0341e-02
    161.80      168.99      168.77     5.7389e-02    5.8665e-02    3.7783e-02    3.8573e-02
    176.05      183.26      183.06     5.4924e-02    5.2005e-02    3.9213e-02    3.7089e-02
    190.35      197.57      197.39     4.8359e-02    4.6470e-02    3.7223e-02    3.5735e-02
    204.69      211.92      211.74     4.4828e-02    4.1754e-02    3.7010e-02    3.4444e-02
    219.06      226.30      226.13     3.7156e-02    3.7669e-02    3.2758e-02    3.3186e-02
    233.46      240.71      240.55     3.1886e-02    3.4088e-02    2.9902e-02    3.1946e-02
    247.89      255.15      254.99     3.0786e-02    3.0923e-02    3.0602e-02    3.0719e-02
    262.34      269.61      269.46     2.9500e-02    2.8106e-02    3.0986e-02    2.9506e-02
    276.82      284.10      283.95     2.4857e-02    2.5588e-02    2.7512e-02    2.8306e-02
    291.31      298.60      298.46     2.2732e-02    2.3327e-02    2.6444e-02    2.7123e-02
    305.83      313.13      312.99     2.0038e-02    2.1290e-02    2.4445e-02    2.5960e-02
    320.37      327.67      327.53     1.8742e-02    1.9450e-02    2.3925e-02    2.4818e-02
    334.92      342.23      342.10     1.6899e-02    1.7784e-02    2.2531e-02    2.3702e-02
    349.49      356.81      356.67     1.5557e-02    1.6273e-02    2.1625e-02    2.2612e-02
    364.08      371.40      371.27     1.4508e-02    1.4900e-02    2.0992e-02    2.1551e-02
    378.68      386.01      385.88     1.4814e-02    1.3650e-02    2.2277e-02    2.0521e-02
    393.29      400.63      400.50     1.2211e-02    1.2512e-02    1.9059e-02    1.9522e-02
    407.92      415.26      415.14     1.2655e-02    1.1474e-02    2.0473e-02    1.8557e-02
    422.56      602.89      601.47     1.3333e-01    1.3111e-01    3.1318e-01    3.0722e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_006_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT3_Contaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.41      112.46      113.05     1.1891e-01    1.2086e-01    5.1487e-02    5.2604e-02
    119.36      126.50      126.08     9.0316e-02    9.7063e-02    4.3987e-02    4.7118e-02
    133.44      140.60      140.30     8.0786e-02    7.8013e-02    4.3733e-02    4.2141e-02
    147.59      154.77      154.52     6.4217e-02    6.6411e-02    3.8266e-02    3.9509e-02
    161.80      168.99      168.77     5.6078e-02    5.7941e-02    3.6486e-02    3.7649e-02
    176.05      183.26      183.06     5.4053e-02    5.1249e-02    3.8139e-02    3.6120e-02
    190.35      197.57      197.38     4.8132e-02    4.5727e-02    3.6613e-02    3.4751e-02
    204.69      211.92      211.74     4.5029e-02    4.1047e-02    3.6740e-02    3.3464e-02
    219.06      226.30      226.13     3.8082e-02    3.7010e-02    3.3181e-02    3.2223e-02
    233.46      240.71      240.55     3.3333e-02    3.3483e-02    3.0892e-02    3.1010e-02
    247.89      255.15      254.99     3.1965e-02    3.0372e-02    3.1401e-02    2.9819e-02
    262.34      269.61      269.46     2.9760e-02    2.7610e-02    3.0892e-02    2.8645e-02
    276.82      284.10      283.95     2.4407e-02    2.5144e-02    2.6697e-02    2.7489e-02
    291.31      298.60      298.46     2.2005e-02    2.2932e-02    2.5299e-02    2.6351e-02
    305.83      313.13      312.99     1.9403e-02    2.0941e-02    2.3392e-02    2.5235e-02
    320.37      327.67      327.53     1.8139e-02    1.9143e-02    2.2883e-02    2.4141e-02
    334.92      342.23      342.10     1.6402e-02    1.7516e-02    2.1612e-02    2.3071e-02
    349.49      356.81      356.68     1.5362e-02    1.6041e-02    2.1103e-02    2.2028e-02
    364.08      371.40      371.27     1.3691e-02    1.4700e-02    1.9578e-02    2.1013e-02
    378.68      386.01      385.88     1.3772e-02    1.3480e-02    2.0468e-02    2.0027e-02
    393.29      400.63      400.50     1.2445e-02    1.2368e-02    1.9197e-02    1.9071e-02
    407.92      415.26      415.14     1.2245e-02    1.1353e-02    1.9578e-02    1.8147e-02
    422.56      602.89      604.88     1.4147e-01    1.3195e-01    3.2838e-01    3.0730e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_008_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT3_Decontaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.41      112.46      113.05     1.2048e-01    1.2033e-01    5.2096e-02    5.2305e-02
    119.36      126.50      126.08     9.1507e-02    9.6643e-02    4.4507e-02    4.6850e-02
    133.44      140.60      140.30     8.1842e-02    7.7675e-02    4.4244e-02    4.1902e-02
    147.59      154.77      154.52     6.4976e-02    6.6123e-02    3.8666e-02    3.9285e-02
    161.80      168.99      168.77     5.6493e-02    5.7690e-02    3.6707e-02    3.7436e-02
    176.05      183.26      183.06     5.3946e-02    5.1027e-02    3.8011e-02    3.5915e-02
    190.35      197.57      197.38     4.7596e-02    4.5529e-02    3.6157e-02    3.4554e-02
    204.69      211.92      211.74     4.3807e-02    4.0870e-02    3.5695e-02    3.3274e-02
    219.06      226.30      226.13     3.6444e-02    3.6850e-02    3.1711e-02    3.2040e-02
    233.46      240.71      240.55     3.1188e-02    3.3338e-02    2.8865e-02    3.0834e-02
    247.89      255.15      254.99     3.0004e-02    3.0241e-02    2.9435e-02    2.9649e-02
    262.34      269.61      269.46     2.8876e-02    2.7491e-02    2.9934e-02    2.8482e-02
    276.82      284.10      283.95     2.4334e-02    2.5035e-02    2.6581e-02    2.7333e-02
    291.31      298.60      298.46     2.2219e-02    2.2833e-02    2.5510e-02    2.6202e-02
    305.83      313.13      312.99     1.9636e-02    2.0850e-02    2.3641e-02    2.5091e-02
    320.37      327.67      327.53     1.8353e-02    1.9060e-02    2.3122e-02    2.4004e-02
    334.92      342.23      342.10     1.6612e-02    1.7440e-02    2.1858e-02    2.2940e-02
    349.49      356.81      356.68     1.5554e-02    1.5971e-02    2.1339e-02    2.1903e-02
    364.08      371.40      371.27     1.3870e-02    1.4636e-02    1.9807e-02    2.0893e-02
    378.68      386.01      385.88     1.3950e-02    1.3421e-02    2.0704e-02    1.9913e-02
    393.29      400.63      400.50     1.2607e-02    1.2314e-02    1.9419e-02    1.8963e-02
    407.92      415.26      415.14     1.2403e-02    1.1304e-02    1.9803e-02    1.8044e-02
    422.56      602.89      604.88     1.4330e-01    1.3138e-01    3.3219e-01    3.0556e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_009_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set output
